// OBJ Importer.js
//
// v.20090411 first version.
// v.20090412 optimized speed, progress shown at Consoel view.
// v.20090413 material import improved.
// v.20100208 setting
// v.20101018 add 'keep vertices order' option.

String.prototype.trim = function() {
	return this.replace(/^[ ]+|[ ]+$/g, '');
}

/*
Vec3D.prototype.toString = function() {
	return '('+this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4)+')';
}
*/
var Vec3D_toString = function( vec ) {
	return '(' + vec.x.toFixed(4) + ', ' + vec.y.toFixed(4) + ', ' + vec.z.toFixed(4) + ')';
}

var obj_list = [];

var v_count = 0;
var f_count = 0;
var f_count_total = 0;

// bench
var st1, st2, st3, st4;

function buildUI(tool) {
	tool.addParameterSeparator("OBJ Importer");
	
	tool.addParameterBool("invert u", 0, 0, 1, true, true);
	tool.addParameterBool("invert v", 1, 0, 1, true, true);
	
	tool.addParameterSeparator("Import Setting");
	
	tool.addParameterBool("keep vertices order", 0, 0, 1, true, true);
	tool.addParameterBool("auto separator", 0, 0, 1, true, true);
	
	tool.addParameterSeparator("Material Setting");
	tool.addParameterBool("import material",0,0,1,true,true);

	tool.addParameterSeparator("Import");
	tool.addParameterBool("import log",0,0,1,true,true);
	tool.addParameterButton("Import","import","importObj");
}

function importObj(tool) {
	var path = OS.runOpenPanel("obj");
	if (path == null) {
		return;
	}
	
	var file = new File(path);
	file.open(READ_MODE);
	if (file.isOpen() == false) {
		return;
	}
	
	print('--- OBJ Importer.js ---');
	// bench
	st1 = new Date().getTime();
	
	var doc = tool.document();
	var obj = null; // obj holder
	var core = null; // core holder
	var separated = null;
	
	var vert_check = [];
	var vi_list = [];
	
	var i, j;
	
	var now = new Date();
	var tmp_v = '/tmp/chv_'+now.getTime();
	var tmp_uv = '/tmp/chuv_'+now.getTime();
	
	var cache_v = new File(tmp_v);
	var cache_uv = new File(tmp_uv);
	 cache_v.open(WRITE_MODE, BIG_ENDIAN);
	cache_uv.open(WRITE_MODE, BIG_ENDIAN);
	
	obj_list.length = 0;
	
	var mat_sels = undefined;
	var v_offset = undefined;
	
	var invert_u = tool.getParameter("invert u");
	var invert_v = tool.getParameter("invert v");
	var mtl_files = [];
	
	var keep_vo = tool.getParameter("keep vertices order");
	var auto_sep = tool.getParameter("auto separator");
	
	v_count = 0;
	f_count = 0;
	f_count_total = 0;
	
	f_pos = undefined;
	cur_pos = 0;
	
	var o_count = 0; // undefined object count
	var vi_count = 0; // total vertices count
	
	var line  = file.readln();
	
	// at first, caching all vertices and uv data.
	var vx,vy,yz;
	
	var vx_max, vy_max, vz_max;
	var vx_min, vy_min, vz_min;
	var v_init = false;
	while ( line != -1 ) {
		// trim -> split
		var data = line.trim().split(/ +/);
		if (data[0] == "v") {
			vx = parseFloat(data[1]);
			vy = parseFloat(data[2]);
			vz = parseFloat(data[3]);
			
			if (! v_init) {
				vx_max = vx;
				vy_max = vy;
				vz_max = vz;
				vx_min = vx;
				vy_min = vy;
				vz_min = vz;
				
				v_init = true;
			} else {
				vx_max = (vx > vx_max)? vx : vx_max;
				vy_max = (vy > vy_max)? vy : vy_max;
				vz_max = (vz > vz_max)? vz : vz_max;
				vx_min = (vx < vx_min)? vx : vx_min;
				vy_min = (vy < vy_min)? vy : vy_min;
				vz_min = (vz < vz_min)? vz : vz_min;
			}
			
			cache_v.writeFloat( vx );
			cache_v.writeFloat( vy );
			cache_v.writeFloat( vz );
			v_count++;
		} else if (data[0] == "vt") {
			var u, v;
			if (invert_u) {
				u = parseFloat( data[1] ) * -1 + 1;
			} else {
				u = parseFloat( data[1] );
			}
			if (invert_v) {
				v = parseFloat( data[2] ) * -1 + 1;
			} else {
				v = parseFloat( data[2] );
			}
			cache_uv.writeFloat( u );
			cache_uv.writeFloat( v );
		} else if (data[0] == "f") {
			if (f_pos == undefined) {
				f_pos = cur_pos;
			}
			f_count_total++;
		} else if (data[0] == "o" || data[0] == "g" || data[0] == "usemtl" || data[0] == "mtllib") {
			if (f_pos == undefined) {
				f_pos = cur_pos;
				print( 'set:'+f_pos );
			}
		}
		cur_pos = file.getpos();
		line = file.readln();
	}
	
	cache_v.close();
	cache_uv.close();
	
	var v_cache_size = cache_v.size();
	var float_size = v_cache_size / (v_count*3);
	
	var bsp_min = new Vec3D( vx_min, vy_min, vz_min );
	var bsp_max = new Vec3D( vx_max, vy_max, vz_max );
	
	print('min:'+Vec3D_toString(bsp_min));
	print('max:'+Vec3D_toString(bsp_max));
	
	var read_v = new File(tmp_v);
	var read_uv = new File(tmp_uv);
	read_v.open(READ_MODE,  BIG_ENDIAN);
	read_uv.open(READ_MODE,  BIG_ENDIAN);
	
	// bench
	st2 = new Date().getTime();
	st3 = st2 - st1;
	st4 = st3/1000;
	print("[bench]:"+st3+" ms ("+st4.toFixed(1)+" s), v_count:"+v_count);
	
	if (keep_vo) {
		var obj_name = file.lastPathComponent();
		obj = doc.addObject(POLYGONOBJ);
		obj.setParameter("name",obj_name);
		core = obj.core();
		core.buildVertexBSP( bsp_min, bsp_max );
		mat_sels = [];
		separated = [ undefined ];
		v_offset = [ vi_count ];
		
		obj_list.push([obj_name, obj, mat_sels, separated, v_offset ]);
		
		while (read_v.size() > read_v.getpos()) {
			var vec = new Vec3D( read_v.readFloat(), read_v.readFloat(), read_v.readFloat() );
			var vi = core.addVertex( false, vec );
			vi_count++;
		}
	}
	
	//print(f_pos+':'+SEEK_SET);
	//file.seek(f_pos, SEEK_SET);
	file.setpos(f_pos);
	
	line = file.readln();
	
	while ( line != -1 ) {
		var data = line.trim().split(/ +/);
		if (data[0] == "o" || data[0] == "g") {
			if (!keep_vo) {
				var grp_name = line.trim().match(/^[og] (.+)$/);
				if (grp_name) {
					var obj_name = grp_name[1];
				} else {
					o_count++;
					var obj_name = "Undefined_"+o_count;
				}
				var create = undefined;
				for (i = 0;i < obj_list.length;i++) {
					if (obj_list[i][0] == obj_name) {
						create = i;
					}
				}
				//
				if (create != undefined) {
					obj = obj_list[create][1];
					core = obj.core();
					mat_sels = obj_list[create][2];
				} else {
					obj = doc.addObject(POLYGONOBJ);
					obj.setParameter("name", obj_name);
					core = obj.core();
					core.buildVertexBSP( bsp_min, bsp_max );
					mat_sels = [];
					separated = [ undefined ];
					v_offset = [ vi_count ];
					
					obj_list.push( [obj_name, obj, mat_sels, separated, v_offset ] );
				}
			}
			//
		} else if (data[0] == "f") {
			if (!core) {
				var obj_name = file.lastPathComponent();
				obj = doc.addObject(POLYGONOBJ);
				obj.setParameter("name",obj_name);
				core = obj.core();
				core.buildVertexBSP( bsp_min, bsp_max );
				mat_sels = [];
				separated = [ undefined ];
				v_offset = [ vi_count ];
				
				obj_list.push([obj_name, obj, mat_sels, separated, v_offset ]);
			}
			var f_list  = [];
			var uv_list = [];
			var vi;
			for (i = data.length - 1;i > 0;i--) {
				var face = data[i].split('/');
				//read_v.seek(  float_size * 3 * (parseInt(face[0]) - 1), SEEK_SET);
				//read_uv.seek( float_size * 2 * (parseInt(face[1]) - 1), SEEK_SET);
				 read_v.setpos( float_size * 3 * (parseInt(face[0]) - 1) ); // x, y, z
				read_uv.setpos( float_size * 2 * (parseInt(face[1]) - 1) );
				
				var vec = new Vec3D( read_v.readFloat(), read_v.readFloat(), read_v.readFloat() );
				
				if (keep_vo) {
					vi = parseInt(face[0]) - 1;
				} else {
					if (vert_check.indexOf( parseInt(face[0]) - 1) == -1) {
						vi = core.addVertex(false, vec);
						vi_count++;
						
						vert_check.push( parseInt( face[0] ) - 1 );
						vi_list[ parseInt( face[0] ) - 1 ] = vi;
					} else {
						//vi = core.addVertex(true, vec);
						vi = vi_list[ parseInt( face[0] ) - 1 ];
					}
				}
				f_list.push( vi );
				uv_list.push( new Vec2D( read_uv.readFloat(), read_uv.readFloat() ) );
			}
			var pi = core.addIndexPolygon(data.length-1, f_list, uv_list);
			core.setPolygonSelection(pi, true);
			f_count++;
			checkProgress();
		} else if (data[0] == "usemtl") {
			var obj_name;
			if (!core) { //
				obj_name = file.lastPathComponent();
				obj = doc.addObject(POLYGONOBJ);
				obj.setParameter("name",obj_name);
				core = obj.core();
				core.buildVertexBSP( bsp_min, bsp_max );
				mat_sels = [];
				separated = [ undefined ];
				v_offset = [ vi_count ];
				
				obj_list.push([obj_name, obj, mat_sels, separated, v_offset ]);
			}
			
			obj_name = obj.getParameter("name");
			var sels = 0;
			for (i = 0;i < obj_list.length;i++) {
				var comp_mat_sels = obj_list[i][2];
				var mat_sels_len = comp_mat_sels.length;
				for (j = 0;j < mat_sels_len;j++) {
					if (obj_name == obj_list[i][0] && comp_mat_sels[j] == data[1]) {
						sels = j+1;
						//
						obj = obj_list[i][1];
						core = obj.core();
						mat_sels = obj_list[i][2];
						separated = obj_list[i][3];
						v_offset = obj_list[i][4];
					}
				}
			}
			
			if (sels > 0) {
				if (sels < 16) {
					core.setActivePolygonSelection(sels);
				} else {
					core.setActivePolygonSelection(0);
				}
			} else { //
				if (!keep_vo && auto_sep && mat_sels.length > 14) { // mat sel
					var create = true;
					for (i = 0;i < obj_list.length;i++) {
						var comp_obj = obj_list[i];
						if (comp_obj[0] == obj_name && comp_obj[2].length < 15) {
							create = false;
							
							obj = comp_obj[1];
							mat_sels = comp_obj[2];
							mat_sels.push(data[1]);
						}
					}
					
					if (create) {
						var sep_num;
						if (separated[0] != undefined) {
							sep_num = separated[0];
						} else {
							separated[0] = 1;
							sep_num = 1;
						}
						
						obj = doc.addObject(POLYGONOBJ);
						obj.setParameter("name", obj_name);
						core = obj.core();
						core.buildVertexBSP( bsp_min, bsp_max );
						mat_sels = [data[1]];
						separated = [ sep_num + 1 ];
						v_offset = [ vi_count ];
						
						obj_list.push([ obj_name, obj, mat_sels, separated, v_offset ]);
					}
				} else {
					mat_sels.push(data[1]);
				}
				
				if (mat_sels.length < 16) {
					core.setActivePolygonSelection(mat_sels.length);
				} else {
					core.setActivePolygonSelection(0);
				}
			}
		} else if (data[0] == "mtllib") {
			for (i = 1;i < data.length;i++) {
				mtl_files.push( data[i] );
			}
		}
		line = file.readln();
	}
	
	print('vi_count:'+vi_count);
	
	core.setActivePolygonSelection(0);
	
	file.close();
	
	if (tool.getParameter("import material")) {
		
		var dir = file.directory();
		for (i = 0;i < mtl_files.length;i++) {
			var mtl_path = dir + '/' + mtl_files[i];
			var mtl_file = new File(mtl_path);
			mtl_file.open(READ_MODE);
			if (mtl_file.isOpen() == false) continue;
			
			line = mtl_file.readln();
			
			var mat = null; // holder
			var mat_name = '';
			while ( line != -1 ) {
				var data = line.split(/ +/);
				if (data[0] == "newmtl") {
					mat_name = data[1];
					mat = doc.addMaterial("Material", mat_name);
				} else if (mat && data[0] == "Ka") { // ambient color
					
				} else if (mat && data[0] == "Kd") { // only RGB type, diffuse color
					if (data[1] != 'spectral' && data[1] != 'xyz') 
						mat.setParameter("colorColor", new Vec4D(parseFloat(data[1]), parseFloat(data[2]), parseFloat(data[3]), 1.0));
				} else if (mat && data[0] == "Ks") { // only RGB type, specular color
					if (data[1] != 'spectral' && data[1] != 'xyz') 
						mat.setParameter("specularColor", new Vec4D(parseFloat(data[1]), parseFloat(data[2]), parseFloat(data[3]), 1.0));
				} else if (mat && data[0] == "d") { // dissolve
					if (data[1].match(/[0-9\.\-]+/)) {
						var val = 1 - parseFloat(data[1]);
						mat.setParameter("transIntensity", val);
					} else if (data[2].match(/[0-9\.\-]+/)) {
						var val = 1 - parseFloat(data[2]);
						mat.setParameter("transIntensity", val);
					}
				} else if (mat && data[0] == "Ns") {
					var specSize = parseFloat(data[1]) / 100 * 128;
					mat.setParameter("specSize", specSize);
				} else if (mat && data[0] == "Ni") {
					if (data[1].match(/[0-9]\.\-/))
						mat.setParameter("transEta", parseFloat(data[1]));
				} else if (mat && data[0] == "map_Kd") {
					var map = data[data.length-1];
					
					setTextureImage(mat, "colorTex", map, mat_name);
				} else if (mat && data[0] == "map_Bump") {
					var map = data[data.length-1];
					
					setTextureImage(mat, "bumpTex", map, mat_name);
				} else if (mat && data[0] == "map_Ks") {
					var map = data[data.length-1];
					
					setTextureImage(mat, "specTex", map, mat_name);
				} else if (mat && data[0] == "refl") {
					var map = data[data.length-1];
					
					setTextureImage(mat, "reflTex", map, mat_name);
				} else if (mat && (data[0] == "map_d" || data[0] == "map_D")) {
					var map = data[data.length-1];
					
					setTextureImage(mat, "transTex", map, mat_name);
					mat.setParameter("transIntensity", 1.0);
				}
				line = mtl_file.readln();
			}
		}
	}
	
	read_v.close();
	read_uv.close();
	
	if ( OS.system ) {
		OS.system('rm '+tmp_v);
		OS.system('rm '+tmp_uv);
	}
	
	for (i = 0;i < obj_list.length;i++) {
		obj = obj_list[i][1];
		core = obj.core();
		core.destroyVertexBSP(); // destroy
		
		core.setActivePolygonSelection(0); // reset poly selection
		
		obj.update();
	}
	
	if (tool.getParameter("import log")) {
		var log_path = file.directory() + '/' + file.lastPathComponent().replace(/\.obj$/, "_import.log");
		var log_file = new File(log_path);
		print(log_path);
		log_file.open(WRITE_MODE);
		if (log_file.isOpen() != false) {
			log_file.setpos( log_file.size() );
			
			log_file.writeln(file.lastPathComponent() + ' imported by OBJ Importer.js script');
			log_file.writeln('at ' + new Date().toString() + ".\n");
			log_file.writeln('### material assignment ###');
			for (i = 0;i < obj_list.length;i++) {
				var obj = obj_list[i][1];
				var obj_name = obj.getParameter("name");
				
				if (obj_list[i][3][0] != undefined) {
					obj_name = obj_name + '_' + obj_list[i][3][0];
					obj.setParameter("name", obj_name);
				}
				log_file.writeln('##  ' + obj_name + '  ## (' + obj_list[i][4][0] + ')');
				mat_sels = obj_list[i][2];
				for (j = 0;j < mat_sels.length;j++) {
					log_file.writeln((j+1) + ':' + mat_sels[j]);
				}
			}
			log_file.close();
		}
	} else {
		print('### material assignment ###');
		for (i = 0;i < obj_list.length;i++) {
			var obj = obj_list[i][1];
			var obj_name = obj.getParameter("name");
			
			if (obj_list[i][3][0] != undefined) {
				obj_name = obj_name + '_' + obj_list[i][3][0];
				obj.setParameter("name", obj_name);
			}
			print('##  ' + obj_name + '  ## (' + obj_list[i][4][0] + ')');
			mat_sels = obj_list[i][2];
			for (j = 0;j < mat_sels.length;j++) {
				print((j+1) + ':' + mat_sels[j]);
			}
		}
	}
	// bench
	st2 = new Date().getTime();
	st3 = st2 - st1;
	st4 = st3/1000;
	print("[bench]:"+st3+" ms ("+st4.toFixed(1)+" s), f_count:"+f_count);

}

function checkProgress() {
	if (f_count % 2000 == 0) {
		var pr = f_count / f_count_total * 100;
		print('progress:'+pr.toFixed(2)+' %');
	}
}

function setTextureImage(mat, param, data, mat_name) {
	var tex_data = data.split(/\./); // detect ext
	var ext = tex_data[tex_data.length-1];
	if (ext.match(/(jpg|gif|bmp|tif|png)/)) {
		var msg = "select "+param+" texture file ("+data+") for "+mat_name;
		var result = OS.messageBox("select "+param+" texture", msg);
		//if (!result) return false;
		print(msg); //
		var tex_path = OS.runOpenPanel(ext);
	} else {
		var tex_path = false;
	}
	if (tex_path) {
		mat.setParameter(param, tex_path);
		return true;
	} else {
		return false;
	}
}